function [indices, states] = indCal_all_mutant(n_WT, n_mut, maxCross)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This Script calculates the state number in the PIP2-synaptotagmin model 
%%%corresponding to the number of syts per vesicle having bound nothing,
%%%pip2, calcium or both

%Input
% n_WT - number of WT syts
% n_mut - number of mutant syts
%Maxcross - number of slots

%Output indices - index numbers states - corresponding number of syts
%having bound nothing, PIP, Ca and both , for both mutant and WT. first
%value: #WT with PIPca, second value: #mutant with PIPca, third value: #WT
%with PIP, fourth: #PIP to mutant, fifth: #Ca to WT, sixth: #Ca to mutant

%%PARTIAL
% nSyts = 3;
% maxCross = 2;
% inds = 0;
count = 0;

indices = zeros(n_WT+1, n_mut+1, n_WT+1, n_mut+1, n_WT+1, n_mut+1);

states_test = zeros(91,6);

for k = 0:min(maxCross, n_WT) %PIPCa to WT
    for l = 0:min((maxCross-k),n_mut) %PIPCa to mut
        for m = 0:min((maxCross-k-l), n_WT-k) %PIP to WT
            for n = 0:min((maxCross-k-l-m), n_mut-l) %PIP to mut
                for p = 0:(n_WT-k-m) %Ca to WT
                    for q = 0:(n_mut-l-n) %Ca to mutant
                        count = count + 1;
                        indices(k+1, l+1,m+1,n+1, p+1, q+1) = count;
%                         print_str = ['crossWT=' num2str(k), ', crossmut=' num2str(l), ', PIPWT=' num2str(n), ...
%                             ', PIPmut=' num2str(m) ', CaWT=' num2str(p), ', Camut=' num2str(q)];
%                         print_str
                        states(count, :) = [k l m n p q];
                        
                    end
                end
            end
        end
    end
end
